/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.menu.component;

import com.technicalitiesmc.lib.client.screen.widget.NumberSelectorWidget;
import com.technicalitiesmc.lib.client.screen.widget.Widget;
import com.technicalitiesmc.lib.menu.MenuComponent;
import com.technicalitiesmc.lib.util.TooltipProvider;
import com.technicalitiesmc.lib.util.value.Reference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.Range;

public class NumberSelectorComponent
extends MenuComponent {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Reference<Integer> reference;
    private final Range<Integer> range;
    @Nullable
    private final TooltipProvider tooltipProvider;

    public NumberSelectorComponent(int x, int y, int width, int height, Reference<Integer> reference, Range<Integer> range, @Nullable TooltipProvider tooltipProvider) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.reference = reference;
        this.range = range;
        this.tooltipProvider = tooltipProvider;
    }

    @Override
    public Supplier<Widget> widgetSupplier() {
        return () -> new NumberSelectorWidget(this.x, this.y, this.width, this.height, this::isEnabled, Reference.of(this.reference::get, this::setAndNotify), this.range, this.tooltipProvider);
    }

    @Override
    public void subscribe(MenuComponent.DataTracker tracker) {
        tracker.trackInt(this.reference);
    }

    @Override
    public void onEvent(FriendlyByteBuf buf) {
        this.reference.set(buf.m_130242_());
    }

    private void setAndNotify(int value) {
        this.reference.set(value);
        this.notifyServer(buf -> buf.m_130130_(value), 10);
    }
}

